package br.com.senior.acesso.sam.customvalidationserver.client;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import br.com.senior.acesso.sam.customvalidationserver.client.model.SamCredentialResponse;

@FeignClient(name = "samClient", url = "https://platform.senior.com.br/t/senior.com.br/sam/1.0")
public interface SamClient {

    @RequestMapping(value = "/credential/card/{id}", method = RequestMethod.GET)
    ResponseEntity<SamCredentialResponse> getCredential(@RequestHeader("authorization") String token, @PathVariable("id") Long id);
}
