package br.com.senior.acesso.sam.customvalidationserver.config;

import lombok.Getter;

@Getter
public enum CardTechnology {
    BARCODE(0), PROXIMITY(1), SMARTCARD(2);

    private int code;

    private CardTechnology(int code) {
        this.code = code;
    }

    public static CardTechnology geCardTechnologyFromCode(int code) {
        for (CardTechnology cardTechnology : values()) {
            if (cardTechnology.getCode() == code) {
                return cardTechnology;
            }
        }
        throw new IllegalArgumentException("Invalid card technology code: " + code);
    }
}
