package br.com.senior.acesso.sam.customvalidationserver.config;

import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.NotBlank;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

import lombok.Getter;
import lombok.Setter;

@Configuration
@ConfigurationProperties(prefix = "sam")
@PropertySource("classpath:application.properties")
@Getter
@Setter
public class ConfigProperties {

    @NotBlank
    private String user;

    @NotBlank
    private String pass;

    @NotNull
    private CardTechnology cardTechnology;

}
