package br.com.senior.acesso.sam.customvalidationserver.controller;

import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import lombok.extern.slf4j.Slf4j;

@RestController
@RequestMapping("/custom-validation")
@Slf4j
public class ServiceController {

    @RequestMapping(method = RequestMethod.GET)
    @ResponseBody
    public ResponseEntity<?> validation( //
    		@RequestParam(value = "validation_type", required = true) String validationType, 
    		@RequestParam(value = "person", required = true) Long person, 
    		@RequestParam(value = "card", required = true) Long card, 
    		@RequestParam(value = "local", required = true) Long local,
    		@RequestParam(value = "reader", required = true) Long reader) {
        log.info("Requisição de validação customizada (Tipo validação: {}, Pessoa: {}, Cartão: {}, Local: {}, Leitora: {})", validationType, person, card, local, reader);
        
        if (card == 12345678) {
        	return new ResponseEntity<>(HttpStatus.OK);
        }
        return new ResponseEntity<>(HttpStatus.UNAUTHORIZED);
    }
}
