package br.com.senior.acesso.sam.customvalidationserver.validation;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import br.com.senior.acesso.sam.customvalidationserver.client.AuthenticationException;
import br.com.senior.acesso.sam.customvalidationserver.client.ClientService;
import br.com.senior.acesso.sam.customvalidationserver.client.model.SamCardResponse;
import br.com.senior.acesso.sam.customvalidationserver.client.model.SamCredentialResponse;
import br.com.senior.acesso.sam.customvalidationserver.config.CardTechnology;
import br.com.senior.acesso.sam.customvalidationserver.config.ConfigProperties;
import lombok.extern.slf4j.Slf4j;

@Service
@Slf4j
public class CardTechnologyValidationService {

    @Autowired
    private ClientService clientService;

    @Autowired
    ConfigProperties configProperties;

    public ValidationResult validateCredentialTechnology(Long cardNumber, Long credential) {

        SamCredentialResponse samCredential;
        try {
            samCredential = clientService.getCredential(credential);
            for (SamCardResponse samCard : samCredential.getCardCredentialList()) {
                if (samCard.getCardNumber().equals(cardNumber)) {
                    if (!configProperties.getCardTechnology().equals(CardTechnology.geCardTechnologyFromCode(samCard.getCardTechnology()))) {
                        return ValidationResult.BLOCKED_ACCESS;
                    }
                }
            }
            return ValidationResult.ALLOWED_ACCESS;
        } catch (AuthenticationException e) {
            log.error(e.getMessage(), e);
            return ValidationResult.BLOCKED_ACCESS;
        }
    }
}
